<?php


// Settings ================================================

$dir        = "uploads/";       // Default directory to upload files
$max_files =  5;                // Maximum Number of files can be uploaded atonce
$max_size   = 5120000;            // Maximum File size in bytes
// Extension of files to be allowed to upload
$file_ext  = array(".gif",".jpg",".jpeg",".png",".zip",".jar",".rar",".sis");


// Don't edit below ----------------------------------------
// Checks if the directory is available or not
if (!is_dir($dir))
die ("Error: The directory <b>($dir)</b> doesn't exist!");
//check if the directory is writable.
if (!is_writeable("$dir"))
die ("Error: The directory <b>($dir)</b> is NOT writable!");


// Begins upload process when form is submitted
if (isset($_POST['upload_form']))
{
echo "<link rel=\"StyleSheet\" type=\"text/css\" href=\"style.css\" />";
echo "<div class=\"top\">Upload results:</div>";

// Do a loop for uploading files based on ($max_files) number of files.
for ($i = 1; $i <= $max_files; $i++)
{

// Define variables to hold the values.
$new_file  = $_FILES['file'.$i];
$file_name = $new_file['name'];

// Replace spaces of file name with underscore
$file_name = str_replace(array(' ','%','p.','P.'),array('_','_','_.','_.'), $file_name);
$file_tmp = $new_file['tmp_name'];
$file_size = $new_file['size'];


// Check file selection
if (!is_uploaded_file($file_tmp))
{
echo "File $i: No File.<br>";
}
else
{
// Checks file extension
$ext = strrchr($file_name,'.');
if (!in_array(strtolower($ext),$file_ext))
{
echo "File $i: ($file_name) Wrong file extension. <br>";
}
else
{
// Checks file size
if ($file_size > $max_size)
{
echo "File $i: ($file_name) Failed to upload. File must be <b>". $max_size / 1024 ."</b> KB. <br>";
}
else
{
// Check for existing file
if(file_exists($dir.$file_name))
{
echo "File $i: ($file_name) was not uploaded! it is already exists! .<br>";
}
else
{
// Uploads file to server
if (move_uploaded_file($file_tmp,$dir.$file_name))
{
echo 'File '.$i.': ('.$file_name.') Uploaded Sucessfully!<br/>FORUM CODE<br/> <textarea>[file]'.$file_name.'[/file]</textarea><br/><br>';
}
else
{
echo "File $i: Failed to upload.<br>";
}
} //if(file_exists).
} //if (file_size).
} //if (limitedext).
} //if (!is_uploaded_file).
} //if (for loop).

echo "<a href=\"$_SERVER[PHP_SELF]\"> Back</a>";
echo "<div class=\"top\">all rights reserved.</div>";
////////////////////////////////////////////////////////////////////////////////

// Shows form to upload
}
else
{
echo "<html><head><title>File Multi-Uploader!</title>";
echo "<link rel=\"StyleSheet\" type=\"text/css\" href=\"style.css\" />";
echo "<div class=\"top\"><b>Multi-Uploader</b></div>";
echo "<div class=\"menu1\">File Extensions Available :<br/><font color='yellow'>.gif, .jpg, .png, .zip, .jar, .rar, .sis</font></div>";
echo "<h3><font color='red'>Attention!!!</font><br/>You can upload multi files with a maximum of ". $max_size / 1024 ." KB</h3>";
echo " <form method=\"post\" action=\"$_SERVER[PHP_SELF]\" enctype=\"multipart/form-data\">";
// show the file input field based on($max_files).
for ($i = 1; $i <= $max_files; $i++) {
echo "File $i:<br/> <input type=\"file\" name=\"file". $i ."\"><br>";
}
echo " <input type=\"hidden\" name=\"MAX_FILE_SIZE\" value=\"$max_size\">
<input type=\"submit\" name=\"upload_form\" value=\"Upload\">
</form></p></body></html> ";
}
?>
